<?php $__env->startSection('title','CARRISOFT V2: BON DE COMMANDE'); ?>


<?php $__env->startSection('content'); ?>

    <style>
        .small-button {
            width: 30px;
            height: 30px;
            padding: 0;
            font-size: 15px;
        }
    </style>

    <main class="col-sm-12 ml-sm-auto col-md-12 pt-0" style="text-decoration: none; margin-top: 5px;">
        >
        <div class="row">
            <div class="col-12 col-sm-6 col-md-7 mb-3">
                <h3 class="ml-5"><?php echo e(__('messages.HISTORIQUE DES INVENTAIRES')); ?></h3>
            </div>
            <div class="col-12 col-sm-6 col-md-5 mb-3">
                <div class="d-flex">
                    <a href="<?php echo e(route('inv.invmagasin')); ?>" class="btn btn-success btn-block text-truncate"><i class="fa FA_PLUS"></i> <?php echo e(__('messages.NOUVEL INVENTAIRE')); ?></a>
                </div>
            </div>
        </div>

        <br>

        <div class="info-box mb-1 flex-column">
            <div class="d-flex align-items-center">
                <div class="col-12 col-md-3 text-center">
                    <label class="font-weight-normal">Date debut </label>
                    <input type="date" name="from_date" id="from_date" class="form-control"/>
                </div>
                <div class="col-12 col-md-3 text-center">
                    <label class="font-weight-normal">Date fin </label>
                    <input type="date" name="to_date" id="to_date" class="form-control"/>
                </div>
                <div class="col-12 col-md-6 justify-content-center" style="margin-top: 30px">
                    <button type="button" name="filter" id="filter" class="btn btn-danger inline"><?php echo e(__('messages.Rechercher')); ?></button>
                    <button type="button" name="imprimer" id="imprimer" class="btn btn-primary inline"><?php echo e(__('messages.Imprimer')); ?></button>
                </div>
            </div>
        </div>

        <div class="col-md-12">
            <div class="info-box">
                <div class="table-responsive">
                    <table class="table table-striped table-bordered" id="histo_inv">
                        <thead>
                        <tr class="cart_menu">
                            <td class="description"><?php echo e(__('messages.Date Inventaire')); ?> </td>
                            <td class="price"><?php echo e(__('messages.Etat')); ?></td>
                            <td class="price"><?php echo e(__('messages.Magasin')); ?></td>
                            <td class="total"><?php echo e(__('messages.Utilisateur')); ?></td>
                            <td><?php echo e(__('messages.Infos')); ?></td>
                            <td><?php echo e(__('messages.Editer')); ?></td>
                            <td><?php echo e(__('messages.Archiver')); ?></td>
                        </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>

        <!--Info inv -->
        <main id="infosInvModal" class="modal fade" role="dialog">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <?php echo e(__('messages.Details inventaire')); ?>

                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <div class="col-md-12" style="max-width: 100%; overflow-x: auto;">
                                <table id="details_inv" class="table">

                                </table>
                            </div>
                        </div>

                        <div class="form-group" align="center">
                            <button type="button" class="btn btn-danger" data-dismiss="modal"><i class="fa fa-windows-close"></i><?php echo e(__('messages.Quitter')); ?></button>
                        </div>
                    </div>
                </div>
            </div>
        </main>

        <!-- Modal pour afficher les réponses -->
        <div class="modal fade" id="responseModal" tabindex="-1" role="dialog" aria-labelledby="responseModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="responseModalLabel">Réponse de l'opération</h5>
                        <!-- Supprimez le bouton de fermeture par défaut -->
                    </div>
                    <div class="modal-body">
                        <p id="responseMessage"></p>
                    </div>
                    <div class="modal-footer">
                        <!-- Utilisez une classe pour rendre le bouton de fermeture en rouge -->
                        <button type="button" class="btn btn-danger" data-dismiss="modal">Fermer</button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Modal -->
        <div class="modal fade" id="archiveModal" tabindex="-1" role="dialog" aria-labelledby="archiveModalLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="archiveModalLabel">Archiver l'inventaire</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p>Voulez-vous vraiment archiver cet inventaire ?</p>
                        <p>Apres archivage, aucune modification n'est plus possible !!!</p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger" data-dismiss="modal">Fermer</button>
                        <button type="button" class="btn btn-primary" id="confirmArchive">Archiver</button>
                    </div>
                </div>
            </div>
        </div>

    </main>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra-js'); ?>
    <script>
        $(document).ready(function(){
            $('.input-daterange').datepicker({
                todayBtn:'linked',
                format:'yyyy-mm-dd',
                autoclose:true
            });

            var inv_id;

            function showModal(responseMessage) {
                $('#responseMessage').text(responseMessage);
                $('#responseModal').modal('show');
            }

            load_data();

            function load_data(from_date = '', to_date = '') {
               histoInv = $('#histo_inv').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url:'<?php echo e(route("inv.histo")); ?>',
                        data:{from_date:from_date, to_date:to_date}
                    },
                    columns: [
                        {
                            data:'date_inventaire',
                            name:'date_inventaire'
                        },
                        {
                            data:'etat',
                            name:'etat'
                        },
                        {
                            data:'libelle',
                            name:'libelle'
                        },
                        {
                            data:'name',
                            name:'name'
                        },
                        {
                            data:'inventaire_id',
                            name:'inventaire_id',
                            render:function (data, type, row) {
                                return "<a href='#' id='"+row.inventaire_id+"' class='btn btn-warning infos'><i class='fa fa-info'></i></a>"}
                        },
                        {
                            data:'inventaire_id',
                            name:'inventaire_id',
                            render: function (data, type, row) {
                                var editButton = "<a href='#' id='" + row.inventaire_id + "' class='btn btn-success edit small-button'><i class='fa fa-edit'></i></a>";

                                if (row.etat === 'Enregistre') {
                                    return "<a href='inv.edite_inv/" + row.inventaire_id + "' id='" + row.inventaire_id + "' class='btn btn-success edit'><i class='fa fa-edit'></i></a>";
                                } else {
                                    return "<button type='button' id='" + row.inventaire_id + "' class='btn btn-secondary btn-sm edit disabled' title='L&#39;inventaire est déjà archivé, ne peut pas être modifié'>" + editButton + "</button>";
                                }
                            }

                        },
                        {
                            data: 'inventaire_id',
                            name: 'inventaire_id',
                            render: function (data, type, row) {
                                var archiveButton = "<a href='#' id='" + row.inventaire_id + "' class='btn btn-primary archive_off small-button'><i class='fa fa-archive'></i></a>";

                                if (row.etat === 'Enregistre') {
                                    return "<a href='#' data-inv-id='" + row.inventaire_id + "' class='btn btn-primary archive' data-toggle='modal'><i class='fa fa-archive'></i></a>";
                                } else {
                                    return "<button type='button' class='btn btn-secondary btn-sm archive_off disabled' title='Inventaire déjà archivé !'>" + archiveButton + "</button>";
                                }
                            }
                        },
                    ],
                });
            }


            $(document).on('click', '.edit', function () {
                if ($(this).hasClass('disabled')) {
                    showModal('L\'inventaire est déjà archivé, donc ne peut plus être modifié');
                }
            });

            $(document).on('click', '.archive_off', function () {
                if ($(this).hasClass('disabled')) {
                    showModal('Inventaire deja archive !');
                }
            });

            $(document).on('click', '.archive', function () {
                inv_id = $(this).data('inv-id');
                $('#archiveModal').modal('show');
            });

            $('#confirmArchive').on('click', function () {
                $('#archiveModal').modal('hide');

                $.ajax({
                    url: 'inv.archiveIventaire/' + inv_id,
                    contentType: false,
                    processData: false,
                    success: function(data) {
                        if (data.error) {
                            showModal(data.error);
                        }
                        if (data.success) {
                            showModal(data.success);
                            histoInv.clear().destroy();
                            load_data();
                        }
                    }
                });
            });


            $('#filter').click(function(){
                var from_date = $('#from_date').val();
                var to_date = $('#to_date').val();
                if(from_date != '' && to_date != '')
                {
                    $('#histo_inv').DataTable().destroy();
                    load_data(from_date, to_date);
                }
                else
                {
                    alert('Selectionner la periode');
                }
            });

            $('#reset').click(function(){
                $('#from_date').val('');
                $('#to_date').val('');
                $('#histo_inv').DataTable().destroy();
                load_data();
            });


            $(document).on('click', '.infos', function(){
                inv_id = $(this).attr('id');
                $('#details_inv').load('inv.infos/'+inv_id);
                $('#infosInvModal').modal('show');
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.adminlayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\gas_online\resources\views/inventaire/histo.blade.php ENDPATH**/ ?>